---
Note type: Meeting
tags:
  - "#meeting_notes"
  - "#Resource"
Resource type: Work
Meeting date: 2024-05-27
Resource date: 2024-04-17
Related areas:
  - "[[Academic service]]"
  - "[[Department affairs]]"
Related projects: 
Related tasks:
  - "[[Review applications for assistant professor of sociology]]"
  - "[[Schedule first-round interviews]]"
  - "[[Check references for shortlisted candidates]]"
Related references: 
Related zettels: 
Related meeting notes: 
Related resources:
  - "[[Sociology Faculty Search Candidate Evaluation Rubric]]"
Related people:
  - "[[Valerie Nguyen]]"
  - "[[Mark Thompson]]"
Creation date: 2024-05-27
Last modified: 2024-05-27
---

## General notes

### External meeting documents

[Faculty Search Applicant Tracking Spreadsheet](<file:///Applicant Tracking.xlsx>)

### Meeting Contents

- Reviewed pool of 120 applicants, 30 met qualifications
- Discussed top 10 picks per committee member
- Selected 10 short-list candidates for first round interviews
- Planned next steps
	- [[Valerie Nguyen]] to schedule Zoom interviews with short-listed candidates
	- [[Mark Thompson]] to assign committee members to conduct reference checks
	- Discussed potential interview questions, teaching demo prompts

### Decisions

- Unanimously approved list of 10 short-listed candidates for first-round interviews
- Scheduled interviews to take place Mar 6 - 10
- Agreed to reconvene after interviews to select finalists for campus visits

### My Actions

- [x] Review materials for assigned semi-finalists
- [ ] Draft questions for research discussion
- [ ] Check references for assigned semi-finalists
- [ ] Prep evaluation notes for committee discussion

## Actionables

> [!task]+ Tasks
>  ```dataview
>TABLE without id row.file.link as Task, join(related-projects) as Project, join(do-date) as "Do Date", join(due-date) as "Due Date", join(task-size) as "Task Size", join(priority) as "Task Priority", 
>choice(done, "✅",":LiBoxSelect:") as Done, 
>choice(waiting-on-someone, "✅",":LiBoxSelect:") as "Waiting on Someone",
>choice(task-amnesty, "✅",":LiBoxSelect:") as "Task Amnesty" 
>FROM "Actionables/Tasks"
>WHERE contains(related-meeting-notes, [[]])
>SORT done ASC, task-amnesty ASC, waiting-on-someone ASC, choice(!do-date, date(2100-01-01), do-date) ASC, task-type DESC, choice(priority = "⚫ TBD", "1", choice(priority = "🔴 A", "2", choice(priority = "🟡 B", "3", choice(priority = "🟢 C", "4", choice(priority = "🟣 D", "5", choice(priority = "🔵 E", "6", "other")))))), choice(task-size = "🎂 Big", "1", choice(task-size = "🍰 Medium", "2", choice(task-size = "🧁 Small", "3", "other"))), priority ASC, choice(!due-date, date(2100-01-01), due-date) ASC, related-resources ASC, related-projects ASC
> ``` 

## Knowledge management system

> [!moc]- Maps of Content
> ```dataview
TABLE without id row.file.link as MoCs
FROM "Knowledge management system/Maps of Content"
WHERE contains(related-meeting-notes, [[]])
SORT file.ctime DESC
LIMIT 50
> ```

> [!reference]- References
> ```dataview
TABLE without id row.file.link as References
FROM "Knowledge management system/References"
WHERE contains(related-meeting-notes, [[]])
SORT file.ctime DESC
LIMIT 50
> ```

> [!zettel]- Zettelkasten
> ```dataview
TABLE without id row.file.link as Zettels
FROM "Knowledge management system/Zettelkasten"
WHERE contains(related-meeting-notes, [[]])
SORT file.ctime DESC
LIMIT 50
> ```

## Project management system

> [!meeting]- Meeting notes
> ```dataview
TABLE without id row.file.link as "Meeting Notes"
FROM "Project management system/Meeting notes"
WHERE contains(related-meeting-notes, [[]])
SORT file.ctime DESC
LIMIT 50
> ```

> [!resource]- Resources
> ```dataview
TABLE without id row.file.link as Resources
FROM "Project management system/Resources"
WHERE contains(related-meeting-notes, [[]])
SORT file.ctime DESC
LIMIT 50
> ```

> [!person]- Rolodex
> ```dataview
TABLE without id row.file.link as People
FROM "Project management system/Rolodex"
WHERE contains(related-meeting-notes, [[]])
SORT file.ctime DESC
LIMIT 50
> ```

